<?php
/**
 * The template to display blog archive
 *
 * @package WordPress
 * @subpackage WINDSOR
 * @since WINDSOR 1.0
 */

/*
Template Name: Blog archive
*/

/**
 * Make page with this template and put it into menu
 * to display posts as blog archive
 * You can setup output parameters (blog style, posts per page, parent category, etc.)
 * in the Theme Options section (under the page content)
 * You can build this page in the WPBakery Page Builder to make custom page layout:
 * just insert %%BLOG_ARCHIVE%% in the desired place of content
 */

// Get template page's content
$windsor_content = '';
$windsor_blog_archive_mask = '%%BLOG_ARCHIVE%%';
$windsor_blog_archive_subst = sprintf('<div class="blog_archive">%s</div>', $windsor_blog_archive_mask);
if ( have_posts() ) {
	the_post(); 
	if (($windsor_content = apply_filters('the_content', get_the_content())) != '') {
		if (($windsor_pos = strpos($windsor_content, $windsor_blog_archive_mask)) !== false) {
			$windsor_content = preg_replace('/(\<p\>\s*)?'.$windsor_blog_archive_mask.'(\s*\<\/p\>)/i', $windsor_blog_archive_subst, $windsor_content);
		} else
			$windsor_content .= $windsor_blog_archive_subst;
		$windsor_content = explode($windsor_blog_archive_mask, $windsor_content);
	}
}

// Make new query
$windsor_args = array(
	'post_type' => 'post',
	'post_status' => current_user_can('read_private_pages') && current_user_can('read_private_posts') ? array('publish', 'private') : 'publish'
);
$windsor_page_number = get_query_var('paged') ? get_query_var('paged') : (get_query_var('page') ? get_query_var('page') : 1);
if ($windsor_page_number > 1) {
	$windsor_args['paged'] = $windsor_page_number;
	$windsor_args['ignore_sticky_posts'] = true;
}
$windsor_cat = windsor_get_theme_option('parent_cat');
if ((int) $windsor_cat > 0)
	$windsor_args['cat'] = (int) $windsor_cat;
$windsor_ppp = windsor_get_theme_option('posts_per_page');
if ((int) $windsor_ppp != 0)
	$windsor_args['posts_per_page'] = (int) $windsor_ppp;

query_posts( $windsor_args );

// Set query vars in the new query!
if (is_array($windsor_content) && count($windsor_content) == 2) {
	set_query_var('blog_archive_start', $windsor_content[0]);
	set_query_var('blog_archive_end', $windsor_content[1]);
}

get_template_part('index');
?>