<?php
/**
 * The Classic template for displaying content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage WINDSOR
 * @since WINDSOR 1.0
 */

$windsor_blog_style = explode('_', windsor_get_theme_option('blog_style'));
$windsor_columns = empty($windsor_blog_style[1]) ? 1 : max(1, $windsor_blog_style[1]);
$windsor_expanded = !windsor_sidebar_present() && windsor_is_on(windsor_get_theme_option('expand_content'));
$windsor_post_format = get_post_format();
$windsor_post_format = empty($windsor_post_format) ? 'standard' : str_replace('post-format-', '', $windsor_post_format);
$windsor_animation = windsor_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_chess post_layout_chess_'.esc_attr($windsor_columns).' post_format_'.esc_attr($windsor_post_format) ); ?>
	<?php echo (!windsor_is_off($windsor_animation) ? ' data-animation="'.esc_attr(windsor_get_animation_classes($windsor_animation)).'"' : ''); ?>
	>

	<?php
	// Add anchor
	if ($windsor_columns == 1 && shortcode_exists('trx_sc_anchor')) {
		echo do_shortcode('[trx_sc_anchor id="post_'.esc_attr(get_the_ID()).'" title="'.the_title_attribute( array( 'echo' => false ) ).'"]');
	}

	// Featured image
	windsor_show_post_featured( array(
											'class' => $windsor_columns == 1 ? 'trx-stretch-height' : '',
											'show_no_image' => true,
											'thumb_bg' => true,
											'thumb_size' => windsor_get_thumb_size(
																	strpos(windsor_get_theme_option('body_style'), 'full')!==false
																		? ( $windsor_columns > 1 ? 'big' : 'original' )
																		: (	$windsor_columns > 1 ? 'med' : 'big')
																	)
											) 
										);

	?><div class="post_inner"><div class="post_inner_content"><?php 

		?><div class="post_header entry-header"><?php 
			// Post title
			the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
			
			// Post meta
			$windsor_post_meta = windsor_show_post_meta(array(
									'categories' => true,
									'date' => true,
									'edit' => $windsor_columns == 1,
									'seo' => false,
									'share' => false,
									'counters' => $windsor_columns < 3 ? 'comments' : '',
									'echo' => false
									)
								);
			windsor_show_layout($windsor_post_meta);
		?></div><!-- .entry-header -->
	
		<div class="post_content entry-content">
			<div class="post_content_inner">
				<?php
				$windsor_show_learn_more = !in_array($windsor_post_format, array('link', 'aside', 'status', 'quote'));
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($windsor_post_format, array('link', 'aside', 'status', 'quote'))) {
					the_content();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
				?>
			</div>
			<?php
			// Post meta
			if (in_array($windsor_post_format, array('link', 'aside', 'status', 'quote'))) {
				windsor_show_layout($windsor_post_meta);
			}
			// More button
			if ( $windsor_show_learn_more ) {
				?><p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'windsor'); ?></a></p><?php
			}
			?>
		</div><!-- .entry-content -->

	</div></div><!-- .post_inner -->

</article>