<?php
/**
 * The Portfolio template for displaying content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage WINDSOR
 * @since WINDSOR 1.0
 */

$windsor_blog_style = explode('_', windsor_get_theme_option('blog_style'));
$windsor_columns = empty($windsor_blog_style[1]) ? 2 : max(2, $windsor_blog_style[1]);
$windsor_post_format = get_post_format();
$windsor_post_format = empty($windsor_post_format) ? 'standard' : str_replace('post-format-', '', $windsor_post_format);
$windsor_animation = windsor_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_portfolio_'.esc_attr($windsor_columns).' post_format_'.esc_attr($windsor_post_format) ); ?>
	<?php echo (!windsor_is_off($windsor_animation) ? ' data-animation="'.esc_attr(windsor_get_animation_classes($windsor_animation)).'"' : ''); ?>
	>

	<?php
	$windsor_image_hover = windsor_get_theme_option('image_hover');
	// Featured image
	windsor_show_post_featured(array(
		'thumb_size' => windsor_get_thumb_size(strpos(windsor_get_theme_option('body_style'), 'full')!==false || $windsor_columns < 3 ? 'masonry-big' : 'masonry'),
		'show_no_image' => true,
		'class' => $windsor_image_hover == 'dots' ? 'hover_with_info' : '',
		'post_info' => $windsor_image_hover == 'dots' ? '<div class="post_info">'.esc_html(get_the_title()).'</div>' : ''
	));
	?>
</article>