<?php
/**
 * Theme storage manipulations
 *
 * @package WordPress
 * @subpackage WINDSOR
 * @since WINDSOR 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Get theme variable
if (!function_exists('windsor_storage_get')) {
	function windsor_storage_get($var_name, $default='') {
		global $WINDSOR_STORAGE;
		return isset($WINDSOR_STORAGE[$var_name]) ? $WINDSOR_STORAGE[$var_name] : $default;
	}
}

// Set theme variable
if (!function_exists('windsor_storage_set')) {
	function windsor_storage_set($var_name, $value) {
		global $WINDSOR_STORAGE;
		$WINDSOR_STORAGE[$var_name] = $value;
	}
}

// Check if theme variable is empty
if (!function_exists('windsor_storage_empty')) {
	function windsor_storage_empty($var_name, $key='', $key2='') {
		global $WINDSOR_STORAGE;
		if (!empty($key) && !empty($key2))
			return empty($WINDSOR_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return empty($WINDSOR_STORAGE[$var_name][$key]);
		else
			return empty($WINDSOR_STORAGE[$var_name]);
	}
}

// Check if theme variable is set
if (!function_exists('windsor_storage_isset')) {
	function windsor_storage_isset($var_name, $key='', $key2='') {
		global $WINDSOR_STORAGE;
		if (!empty($key) && !empty($key2))
			return isset($WINDSOR_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return isset($WINDSOR_STORAGE[$var_name][$key]);
		else
			return isset($WINDSOR_STORAGE[$var_name]);
	}
}

// Inc/Dec theme variable with specified value
if (!function_exists('windsor_storage_inc')) {
	function windsor_storage_inc($var_name, $value=1) {
		global $WINDSOR_STORAGE;
		if (empty($WINDSOR_STORAGE[$var_name])) $WINDSOR_STORAGE[$var_name] = 0;
		$WINDSOR_STORAGE[$var_name] += $value;
	}
}

// Concatenate theme variable with specified value
if (!function_exists('windsor_storage_concat')) {
	function windsor_storage_concat($var_name, $value) {
		global $WINDSOR_STORAGE;
		if (empty($WINDSOR_STORAGE[$var_name])) $WINDSOR_STORAGE[$var_name] = '';
		$WINDSOR_STORAGE[$var_name] .= $value;
	}
}

// Get array (one or two dim) element
if (!function_exists('windsor_storage_get_array')) {
	function windsor_storage_get_array($var_name, $key, $key2='', $default='') {
		global $WINDSOR_STORAGE;
		if (empty($key2))
			return !empty($var_name) && !empty($key) && isset($WINDSOR_STORAGE[$var_name][$key]) ? $WINDSOR_STORAGE[$var_name][$key] : $default;
		else
			return !empty($var_name) && !empty($key) && isset($WINDSOR_STORAGE[$var_name][$key][$key2]) ? $WINDSOR_STORAGE[$var_name][$key][$key2] : $default;
	}
}

// Set array element
if (!function_exists('windsor_storage_set_array')) {
	function windsor_storage_set_array($var_name, $key, $value) {
		global $WINDSOR_STORAGE;
		if (!isset($WINDSOR_STORAGE[$var_name])) $WINDSOR_STORAGE[$var_name] = array();
		if ($key==='')
			$WINDSOR_STORAGE[$var_name][] = $value;
		else
			$WINDSOR_STORAGE[$var_name][$key] = $value;
	}
}

// Set two-dim array element
if (!function_exists('windsor_storage_set_array2')) {
	function windsor_storage_set_array2($var_name, $key, $key2, $value) {
		global $WINDSOR_STORAGE;
		if (!isset($WINDSOR_STORAGE[$var_name])) $WINDSOR_STORAGE[$var_name] = array();
		if (!isset($WINDSOR_STORAGE[$var_name][$key])) $WINDSOR_STORAGE[$var_name][$key] = array();
		if ($key2==='')
			$WINDSOR_STORAGE[$var_name][$key][] = $value;
		else
			$WINDSOR_STORAGE[$var_name][$key][$key2] = $value;
	}
}

// Merge array elements
if (!function_exists('windsor_storage_merge_array')) {
	function windsor_storage_merge_array($var_name, $key, $value) {
		global $WINDSOR_STORAGE;
		if (!isset($WINDSOR_STORAGE[$var_name])) $WINDSOR_STORAGE[$var_name] = array();
		if ($key==='')
			$WINDSOR_STORAGE[$var_name] = array_merge($WINDSOR_STORAGE[$var_name], $value);
		else
			$WINDSOR_STORAGE[$var_name][$key] = array_merge($WINDSOR_STORAGE[$var_name][$key], $value);
	}
}

// Add array element after the key
if (!function_exists('windsor_storage_set_array_after')) {
	function windsor_storage_set_array_after($var_name, $after, $key, $value='') {
		global $WINDSOR_STORAGE;
		if (!isset($WINDSOR_STORAGE[$var_name])) $WINDSOR_STORAGE[$var_name] = array();
		if (is_array($key))
			windsor_array_insert_after($WINDSOR_STORAGE[$var_name], $after, $key);
		else
			windsor_array_insert_after($WINDSOR_STORAGE[$var_name], $after, array($key=>$value));
	}
}

// Add array element before the key
if (!function_exists('windsor_storage_set_array_before')) {
	function windsor_storage_set_array_before($var_name, $before, $key, $value='') {
		global $WINDSOR_STORAGE;
		if (!isset($WINDSOR_STORAGE[$var_name])) $WINDSOR_STORAGE[$var_name] = array();
		if (is_array($key))
			windsor_array_insert_before($WINDSOR_STORAGE[$var_name], $before, $key);
		else
			windsor_array_insert_before($WINDSOR_STORAGE[$var_name], $before, array($key=>$value));
	}
}

// Push element into array
if (!function_exists('windsor_storage_push_array')) {
	function windsor_storage_push_array($var_name, $key, $value) {
		global $WINDSOR_STORAGE;
		if (!isset($WINDSOR_STORAGE[$var_name])) $WINDSOR_STORAGE[$var_name] = array();
		if ($key==='')
			array_push($WINDSOR_STORAGE[$var_name], $value);
		else {
			if (!isset($WINDSOR_STORAGE[$var_name][$key])) $WINDSOR_STORAGE[$var_name][$key] = array();
			array_push($WINDSOR_STORAGE[$var_name][$key], $value);
		}
	}
}

// Pop element from array
if (!function_exists('windsor_storage_pop_array')) {
	function windsor_storage_pop_array($var_name, $key='', $defa='') {
		global $WINDSOR_STORAGE;
		$rez = $defa;
		if ($key==='') {
			if (isset($WINDSOR_STORAGE[$var_name]) && is_array($WINDSOR_STORAGE[$var_name]) && count($WINDSOR_STORAGE[$var_name]) > 0) 
				$rez = array_pop($WINDSOR_STORAGE[$var_name]);
		} else {
			if (isset($WINDSOR_STORAGE[$var_name][$key]) && is_array($WINDSOR_STORAGE[$var_name][$key]) && count($WINDSOR_STORAGE[$var_name][$key]) > 0) 
				$rez = array_pop($WINDSOR_STORAGE[$var_name][$key]);
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if (!function_exists('windsor_storage_inc_array')) {
	function windsor_storage_inc_array($var_name, $key, $value=1) {
		global $WINDSOR_STORAGE;
		if (!isset($WINDSOR_STORAGE[$var_name])) $WINDSOR_STORAGE[$var_name] = array();
		if (empty($WINDSOR_STORAGE[$var_name][$key])) $WINDSOR_STORAGE[$var_name][$key] = 0;
		$WINDSOR_STORAGE[$var_name][$key] += $value;
	}
}

// Concatenate array element with specified value
if (!function_exists('windsor_storage_concat_array')) {
	function windsor_storage_concat_array($var_name, $key, $value) {
		global $WINDSOR_STORAGE;
		if (!isset($WINDSOR_STORAGE[$var_name])) $WINDSOR_STORAGE[$var_name] = array();
		if (empty($WINDSOR_STORAGE[$var_name][$key])) $WINDSOR_STORAGE[$var_name][$key] = '';
		$WINDSOR_STORAGE[$var_name][$key] .= $value;
	}
}

// Call object's method
if (!function_exists('windsor_storage_call_obj_method')) {
	function windsor_storage_call_obj_method($var_name, $method, $param=null) {
		global $WINDSOR_STORAGE;
		if ($param===null)
			return !empty($var_name) && !empty($method) && isset($WINDSOR_STORAGE[$var_name]) ? $WINDSOR_STORAGE[$var_name]->$method(): '';
		else
			return !empty($var_name) && !empty($method) && isset($WINDSOR_STORAGE[$var_name]) ? $WINDSOR_STORAGE[$var_name]->$method($param): '';
	}
}

// Get object's property
if (!function_exists('windsor_storage_get_obj_property')) {
	function windsor_storage_get_obj_property($var_name, $prop, $default='') {
		global $WINDSOR_STORAGE;
		return !empty($var_name) && !empty($prop) && isset($WINDSOR_STORAGE[$var_name]->$prop) ? $WINDSOR_STORAGE[$var_name]->$prop : $default;
	}
}
?>