<?php
/**
 * The template for homepage posts with "Portfolio" style
 *
 * @package WordPress
 * @subpackage WINDSOR
 * @since WINDSOR 1.0
 */

windsor_storage_set('blog_archive', true);

// Load scripts for both 'Gallery' and 'Portfolio' layouts!
wp_enqueue_script( 'classie', windsor_get_file_url('js/theme.gallery/classie.min.js'), array(), null, true );
wp_enqueue_script( 'imagesloaded', windsor_get_file_url('js/theme.gallery/imagesloaded.min.js'), array(), null, true );
wp_enqueue_script( 'masonry', windsor_get_file_url('js/theme.gallery/masonry.min.js'), array(), null, true );
wp_enqueue_script( 'modernizr', windsor_get_file_url('js/theme.gallery/modernizr.min.js'), array(), null, true);
wp_enqueue_script( 'windsor-gallery-script', windsor_get_file_url('js/theme.gallery/theme.gallery.js'), array(), null, true );

get_header(); 

if (have_posts()) {

	echo get_query_var('blog_archive_start');

	$windsor_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$windsor_sticky_out = is_array($windsor_stickies) && count($windsor_stickies) > 0 && get_query_var( 'paged' ) < 1;
	
	// Show filters
	$windsor_show_filters = windsor_get_theme_option('show_filters');
	$windsor_tabs = array();
	if (!windsor_is_off($windsor_show_filters)) {
		$windsor_cat = windsor_get_theme_option('parent_cat');
		$windsor_args = array(
			'type'			=> 'post',
			'child_of'		=> $windsor_cat,
			'orderby'		=> 'name',
			'order'			=> 'ASC',
			'hide_empty'	=> 1,
			'hierarchical'	=> 0,
			'exclude'		=> '',
			'include'		=> '',
			'number'		=> '',
			'taxonomy'		=> 'category',
			'pad_counts'	=> false
		);
		$windsor_portfolio_list = get_categories($windsor_args);
		if (is_array($windsor_portfolio_list) && count($windsor_portfolio_list) > 0) {
			$windsor_tabs[$windsor_cat] = esc_html__('All', 'windsor');
			foreach ($windsor_portfolio_list as $windsor_term) {
				if (isset($windsor_term->term_id)) $windsor_tabs[$windsor_term->term_id] = $windsor_term->name;
			}
		}
	}
	if (count($windsor_tabs) > 0) {
		$windsor_portfolio_filters_ajax = true;
		$windsor_portfolio_filters_active = $windsor_cat;
		$windsor_portfolio_filters_id = 'portfolio_filters';
		if (!is_customize_preview())
			wp_enqueue_script('jquery-ui-tabs', false, array('jquery', 'jquery-ui-core'), null, true);
		?>
		<div class="portfolio_filters windsor_tabs windsor_tabs_ajax">
			<ul class="portfolio_titles windsor_tabs_titles">
				<?php
				foreach ($windsor_tabs as $windsor_id=>$windsor_title) {
					?><li><a href="<?php echo esc_url(windsor_get_hash_link(sprintf('#%s_%s_content', $windsor_portfolio_filters_id, $windsor_id))); ?>" data-tab="<?php echo esc_attr($windsor_id); ?>"><?php echo esc_html($windsor_title); ?></a></li><?php
				}
				?>
			</ul>
			<?php
			$windsor_ppp = windsor_get_theme_option('posts_per_page');
			if (windsor_is_inherit($windsor_ppp)) $windsor_ppp = '';
			foreach ($windsor_tabs as $windsor_id=>$windsor_title) {
				$windsor_portfolio_need_content = $windsor_id==$windsor_portfolio_filters_active || !$windsor_portfolio_filters_ajax;
				?>
				<div id="<?php echo esc_attr(sprintf('%s_%s_content', $windsor_portfolio_filters_id, $windsor_id)); ?>"
					class="portfolio_content windsor_tabs_content"
					data-blog-template="<?php echo esc_attr(windsor_storage_get('blog_template')); ?>"
					data-blog-style="<?php echo esc_attr(windsor_get_theme_option('blog_style')); ?>"
					data-posts-per-page="<?php echo esc_attr($windsor_ppp); ?>"
					data-cat="<?php echo esc_attr($windsor_id); ?>"
					data-parent-cat="<?php echo esc_attr($windsor_cat); ?>"
					data-need-content="<?php echo (false===$windsor_portfolio_need_content ? 'true' : 'false'); ?>"
				>
					<?php
					if ($windsor_portfolio_need_content) 
						windsor_show_portfolio_posts(array(
							'cat' => $windsor_id,
							'parent_cat' => $windsor_cat,
							'page' => 1,
							'sticky' => $windsor_sticky_out
							)
						);
					?>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	} else {
		windsor_show_portfolio_posts(array(
			'cat' => $windsor_id,
			'parent_cat' => $windsor_cat,
			'page' => 1,
			'sticky' => $windsor_sticky_out
			)
		);
	}

	echo get_query_var('blog_archive_end');

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>