<?php
/* Essential Grid support functions
------------------------------------------------------------------------------- */


// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('windsor_contact_form_theme_setup9')) {
	add_action( 'after_setup_theme', 'windsor_contact_form_theme_setup9', 9 );
	function windsor_contact_form_theme_setup9() {
		if (windsor_exists_essgrids()) {
			add_action( 'wp_enqueue_scripts', 									'windsor_contact_form_frontend_scripts', 1100 );
			add_filter( 'windsor_filter_merge_styles',					'windsor_contact_form_merge_styles' );
			add_filter( 'windsor_filter_get_css',						'windsor_contact_form_get_css', 10, 3 );
		}
		if (is_admin()) {
			add_filter( 'windsor_filter_tgmpa_required_plugins',		'windsor_contact_form_tgmpa_required_plugins' );
		}
	}
}

// Check if plugin installed and activated
if ( !function_exists( 'windsor_exists_essgrids' ) ) {
	function windsor_exists_essgrids() {
		return class_exists('WPCF7') && class_exists('WPCF7_ContactForm');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'windsor_contact_form_tgmpa_required_plugins' ) ) {
	
	function windsor_contact_form_tgmpa_required_plugins($list=array()) {
		if (in_array('contact-form-7', windsor_storage_get('required_plugins'))) {
				$list[] = array(
						'name' 		=> esc_html__('Contact Form 7', 'windsor'),
						'slug' 		=> 'contact-form-7',
						'required' 	=> false
					);
		}
		return $list;
	}
}
	
// Enqueue WooCommerce custom styles
if ( !function_exists( 'windsor_contact_form_frontend_scripts' ) ) {
	
	function windsor_contact_form_frontend_scripts() {
	}
}
	
// Merge custom styles
if ( !function_exists( 'windsor_contact_form_merge_styles' ) ) {
	
	function windsor_contact_form_merge_styles($list) {
		return $list;
	}
}


// Add plugin's specific styles into color scheme
//------------------------------------------------------------------------

// Add styles into CSS
if ( !function_exists( 'windsor_contact_form_get_css' ) ) {
	
	function windsor_contact_form_get_css($css, $colors, $fonts) {
		if (isset($css['fonts']) && $fonts) {
			$css['fonts'] .= <<<CSS


CSS;
		}

		if (isset($css['colors']) && $colors) {
			$css['colors'] .= <<<CSS

		
CSS;
		}
		
		return $css;
	}
}
?>