<?php
/* Essential Grid support functions
------------------------------------------------------------------------------- */


// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('windsor_essgrids_theme_setup9')) {
	add_action( 'after_setup_theme', 'windsor_essgrids_theme_setup9', 9 );
	function windsor_essgrids_theme_setup9() {
		if (windsor_exists_essgrids()) {
			add_action( 'wp_enqueue_scripts', 									'windsor_essgrids_frontend_scripts', 1100 );
			add_filter( 'windsor_filter_merge_styles',					'windsor_essgrids_merge_styles' );
			add_filter( 'windsor_filter_get_css',						'windsor_essgrids_get_css', 10, 3 );
		}
		if (is_admin()) {
			add_filter( 'windsor_filter_tgmpa_required_plugins',		'windsor_essgrids_tgmpa_required_plugins' );
		}
	}
}

// Check if plugin installed and activated
if ( !function_exists( 'windsor_exists_essgrids' ) ) {
	function windsor_exists_essgrids() {
		return defined('EG_PLUGIN_PATH');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'windsor_essgrids_tgmpa_required_plugins' ) ) {
	
	function windsor_essgrids_tgmpa_required_plugins($list=array()) {
		if (in_array('essential-grid', windsor_storage_get('required_plugins'))) {
			$path = windsor_get_file_dir('plugins/install/essential-grid.zip');
			if (file_exists($path)) {
				$list[] = array(
						'name' 		=> esc_html__('Essential Grid', 'windsor'),
						'slug' 		=> 'essential-grid',
						'source'	=> $path,
						'version'   => '2.3.3',
						'required' 	=> false
					);
			}
		}
		return $list;
	}
}
	
// Enqueue WooCommerce custom styles
if ( !function_exists( 'windsor_essgrids_frontend_scripts' ) ) {
	
	function windsor_essgrids_frontend_scripts() {
			if (windsor_is_on(windsor_get_theme_option('debug_mode')) && file_exists(windsor_get_file_dir('css/plugin.essgrids.css')))
                wp_enqueue_style( 'essgrids',  windsor_get_file_url('css/plugin.essgrids.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'windsor_essgrids_merge_styles' ) ) {
	
	function windsor_essgrids_merge_styles($list) {
		$list[] = 'css/plugin.essgrids.css';
		return $list;
	}
}


// Add plugin's specific styles into color scheme
//------------------------------------------------------------------------

// Add styles into CSS
if ( !function_exists( 'windsor_essgrids_get_css' ) ) {
	
	function windsor_essgrids_get_css($css, $colors, $fonts) {
		if (isset($css['fonts']) && $fonts) {
			$css['fonts'] .= <<<CSS

.esg-grid .eg-winelist-element-25, .esg-grid .eg-winelist-element-30 {
	font-family: {$fonts['h5']['family']};
}
.esg-grid .eg-winelist-element-0 {
	font-family: {$fonts['h6']['family']};
}

CSS;
		}

		if (isset($css['colors']) && $colors) {
			$css['colors'] .= <<<CSS

.esg-grid .eg-winelist-element-30 {
	color: {$colors['text_dark']};
}
.esg-grid .eg-winelist-element-30:hover {
	color: {$colors['text_link']};
}
		
CSS;
		}
		
		return $css;
	}
}
?>