<?php
/* Mail Chimp support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('windsor_mailchimp_theme_setup9')) {
	add_action( 'after_setup_theme', 'windsor_mailchimp_theme_setup9', 9 );
	function windsor_mailchimp_theme_setup9() {
		if (windsor_exists_mailchimp()) {
			add_action( 'wp_enqueue_scripts',							'windsor_mailchimp_frontend_scripts', 1100 );
			add_filter( 'windsor_filter_merge_styles',					'windsor_mailchimp_merge_styles');
			add_filter( 'windsor_filter_get_css',						'windsor_mailchimp_get_css', 10, 3);
		}
		if (is_admin()) {
			add_filter( 'windsor_filter_tgmpa_required_plugins',		'windsor_mailchimp_tgmpa_required_plugins' );
		}
	}
}

// Check if Instagram Feed installed and activated
if ( !function_exists( 'windsor_exists_mailchimp' ) ) {
	function windsor_exists_mailchimp() {
		return function_exists('__mc4wp_load_plugin') || defined('MC4WP_VERSION');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'windsor_mailchimp_tgmpa_required_plugins' ) ) {
	
	function windsor_mailchimp_tgmpa_required_plugins($list=array()) {
		if (in_array('mailchimp-for-wp', windsor_storage_get('required_plugins')))
			$list[] = array(
				'name' 		=> esc_html__('MailChimp for WP', 'windsor'),
				'slug' 		=> 'mailchimp-for-wp',
				'required' 	=> false
			);
		return $list;
	}
}


// Custom styles and scripts
//------------------------------------------------------------------------

// Enqueue custom styles
if ( !function_exists( 'windsor_mailchimp_frontend_scripts' ) ) {
	
	function windsor_mailchimp_frontend_scripts() {
		if (windsor_exists_mailchimp()) {
			if (windsor_is_on(windsor_get_theme_option('debug_mode')) && file_exists(windsor_get_file_dir('css/plugin.mailchimp-for-wp.css')))
                wp_enqueue_style( 'mailchimp-for-wp',  windsor_get_file_url('css/plugin.mailchimp-for-wp.css'), array(), null );
		}
	}
}
	
// Merge custom styles
if ( !function_exists( 'windsor_mailchimp_merge_styles' ) ) {
	
	function windsor_mailchimp_merge_styles($list) {
		$list[] = 'css/plugin.mailchimp-for-wp.css';
		return $list;
	}
}

// Add css styles into global CSS stylesheet
if (!function_exists('windsor_mailchimp_get_css')) {
	
	function windsor_mailchimp_get_css($css, $colors, $fonts) {
		
		if (isset($css['fonts']) && $fonts) {
			$css['fonts'] .= <<<CSS

CSS;
		}
		
		if (isset($css['colors']) && $colors) {
			$css['colors'] .= <<<CSS

.mc4wp-form input[type="email"] {
	background-color: {$colors['alter_dark']};
	border-color: {$colors['alter_dark']};
	color: {$colors['bg_color']};
}
.mc4wp-form input[type="submit"] {
	background-color: {$colors['alter_link']};
	color: {$colors['inverse_text']};
}
.mc4wp-form input[type="submit"]:hover {
	background-color: {$colors['alter_dark']};
	color: {$colors['alter_bg_color']};
}

CSS;
		}

		return $css;
	}
}
?>