<?php
/* Revolution Slider support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('windsor_revslider_theme_setup9')) {
	add_action( 'after_setup_theme', 'windsor_revslider_theme_setup9', 9 );
	function windsor_revslider_theme_setup9() {
		if (is_admin()) {
			add_filter( 'windsor_filter_tgmpa_required_plugins',		'windsor_revslider_tgmpa_required_plugins' );
		}
	}
}

// Check if RevSlider installed and activated
if ( !function_exists( 'windsor_exists_revslider' ) ) {
	function windsor_exists_revslider() {
		return function_exists('rev_slider_shortcode');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'windsor_revslider_tgmpa_required_plugins' ) ) {
	
	function windsor_revslider_tgmpa_required_plugins($list=array()) {
		if (in_array('revslider', windsor_storage_get('required_plugins'))) {
			$path = windsor_get_file_dir('plugins/install/revslider.zip');
			if (file_exists($path)) {
				$list[] = array(
						'name' 		=> esc_html__('Revolution Slider', 'windsor'),
						'slug' 		=> 'revslider',
						'source'	=> $path,
                        'version'   => '6.3.6',
						'required' 	=> false
					);
			}
		}
		return $list;
	}
}
?>