<?php
/* WPBakery Page Builder Extensions Bundle support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('windsor_vc_extensions_theme_setup9')) {
	add_action( 'after_setup_theme', 'windsor_vc_extensions_theme_setup9', 9 );
	function windsor_vc_extensions_theme_setup9() {
		if (windsor_exists_visual_composer()) {
			add_action( 'wp_enqueue_scripts', 										'windsor_vc_extensions_frontend_scripts', 1100 );
			add_filter( 'windsor_filter_merge_styles',						'windsor_vc_extensions_merge_styles' );
			add_filter( 'windsor_filter_get_css',							'windsor_vc_extensions_get_css', 10, 3 );
		}
	
		if (is_admin()) {
			add_filter( 'windsor_filter_tgmpa_required_plugins',		'windsor_vc_extensions_tgmpa_required_plugins' );
		}
	}
}

// Check if VC Extensions installed and activated
if ( !function_exists( 'windsor_exists_vc_extensions' ) ) {
	function windsor_exists_vc_extensions() {
		return class_exists('Vc_Manager') && class_exists('VC_Extensions_CQBundle');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'windsor_vc_extensions_tgmpa_required_plugins' ) ) {
	
	function windsor_vc_extensions_tgmpa_required_plugins($list=array()) {
		if (in_array('vc-extensions-bundle', windsor_storage_get('required_plugins'))) {
			$path = windsor_get_file_dir('plugins/install/vc-extensions-bundle.zip');
			if (file_exists($path)) {
				$list[] = array(
					'name' 		=> esc_html__('WPBakery Page Builder Extensions Bundle', 'windsor'),
					'slug' 		=> 'vc-extensions-bundle',
					'source'	=> $path,
                    'version'   => '3.6.1',
					'required' 	=> false
				);
			}
		}
		return $list;
	}
}
	
// Enqueue VC custom styles
if ( !function_exists( 'windsor_vc_extensions_frontend_scripts' ) ) {
	
	function windsor_vc_extensions_frontend_scripts() {
		if (windsor_is_on(windsor_get_theme_option('debug_mode')) && file_exists(windsor_get_file_dir('css/plugin.vc-extensions-bundle.css')))
            wp_enqueue_style( 'vc-extensions-bundle',  windsor_get_file_url('css/plugin.vc-extensions-bundle.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'windsor_vc_extensions_merge_styles' ) ) {
	
	function windsor_vc_extensions_merge_styles($list) {
		$list[] = 'css/plugin.vc-extensions-bundle.css';
		return $list;
	}
}




// Add VC specific styles into color scheme
//------------------------------------------------------------------------

// Add styles into CSS
if ( !function_exists( 'windsor_vc_extensions_get_css' ) ) {
	
	function windsor_vc_extensions_get_css($css, $colors, $fonts) {
		if (isset($css['fonts']) && $fonts) {
			$css['fonts'] .= <<<CSS

CSS;
		}

		if (isset($css['colors']) && $colors) {
			$css['colors'] .= <<<CSS

CSS;
		}
		
		return $css;
	}
}
?>