<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage WINDSOR
 * @since WINDSOR 1.0
 */

$windsor_sidebar_position = windsor_get_theme_option('sidebar_position');
if (windsor_sidebar_present()) {
	$windsor_sidebar_name = windsor_get_theme_option('sidebar_widgets');
	windsor_storage_set('current_sidebar', 'sidebar');
	?>
	<div class="sidebar <?php echo esc_attr($windsor_sidebar_position); ?> widget_area<?php if (!windsor_is_inherit(windsor_get_theme_option('sidebar_scheme'))) echo ' scheme_'.esc_attr(windsor_get_theme_option('sidebar_scheme')); ?>" role="complementary">
		<div class="sidebar_inner">
			<?php
			ob_start();
			do_action( 'windsor_action_before_sidebar' );
            if ( is_active_sidebar( $windsor_sidebar_name ) ) {
                dynamic_sidebar( $windsor_sidebar_name );
            }
			do_action( 'windsor_action_after_sidebar' );
			$windsor_out = ob_get_contents();
			ob_end_clean();
			windsor_show_layout(preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $windsor_out));
			?>
		</div><!-- /.sidebar_inner -->
	</div><!-- /.sidebar -->
	<?php
}
?>