<?php
/**
 * The template 'Style 1' to displaying related posts
 *
 * @package WordPress
 * @subpackage WINDSOR
 * @since WINDSOR 1.0
 */

// Thumb image
$windsor_thumb_image = has_post_thumbnail() 
			? wp_get_attachment_image_src(get_post_thumbnail_id(), windsor_get_thumb_size('portrait')) 
			: ( (float) wp_get_theme()->get('Version') > 1.0
					? windsor_get_no_image_placeholder()
					: ''
				);
if (is_array($windsor_thumb_image)) $windsor_thumb_image = $windsor_thumb_image[0];
$windsor_link = get_permalink();
?>
<div class="related_item related_item_style_1">
	<?php if (!empty($windsor_thumb_image)) { ?>
		<div class="post_featured <?php echo esc_attr(windsor_add_inline_style('background-image:url('.esc_url($windsor_thumb_image).');')); ?>">
			<div class="post_header entry-header">
				<div class="post_categories"><?php the_category( '' ); ?></div>
				<h6 class="post_title entry-title"><a href="<?php echo esc_url($windsor_link); ?>"><?php echo the_title(); ?></a></h6>
				<?php
				if ( in_array(get_post_type(), array( 'post', 'attachment' ) ) ) {
					?><span class="post_date"><a href="<?php echo esc_url($windsor_link); ?>"><?php echo windsor_get_date(); ?></a></span><?php
				}
				?>
			</div>
		</div>
	<?php } ?>
</div>
