<?php
/**
 * The template for displaying posts in widgets and/or in the search results
 *
 * @package WordPress
 * @subpackage WINDSOR
 * @since WINDSOR 1.0
 */

$windsor_post_id    = get_the_ID();
$windsor_post_date  = windsor_get_date();
$windsor_post_title = get_the_title();
$windsor_post_link  = get_permalink();
$windsor_post_author_id   = get_the_author_meta('ID');
$windsor_post_author_name = get_the_author_meta('display_name');
$windsor_post_author_url  = get_author_posts_url($windsor_post_author_id, '');

$windsor_args = get_query_var('windsor_args_widgets_posts');
$windsor_show_date = isset($windsor_args['show_date']) ? (int) $windsor_args['show_date'] : 1;
$windsor_show_image = isset($windsor_args['show_image']) ? (int) $windsor_args['show_image'] : 1;
$windsor_show_author = isset($windsor_args['show_author']) ? (int) $windsor_args['show_author'] : 1;
$windsor_show_counters = isset($windsor_args['show_counters']) ? (int) $windsor_args['show_counters'] : 1;
$windsor_show_categories = isset($windsor_args['show_categories']) ? (int) $windsor_args['show_categories'] : 1;

$windsor_output = windsor_storage_get('windsor_output_widgets_posts');

$windsor_post_counters_output = '';
if ( $windsor_show_counters ) {
	$windsor_post_counters_output = '<span class="post_info_item post_info_counters">'
								. windsor_get_post_counters('comments')
							. '</span>';
}


$windsor_output .= '<article class="post_item with_thumb">';

if ($windsor_show_image) {
	$windsor_post_thumb = get_the_post_thumbnail($windsor_post_id, windsor_get_thumb_size('tiny'), array(
		'alt' => the_title_attribute( array( 'echo' => false ) )
    ));
	if ($windsor_post_thumb) $windsor_output .= '<div class="post_thumb">' . ($windsor_post_link ? '<a href="' . esc_url($windsor_post_link) . '">' : '') . ($windsor_post_thumb) . ($windsor_post_link ? '</a>' : '') . '</div>';
}

$windsor_output .= '<div class="post_content">'
			. ($windsor_show_categories 
					? '<div class="post_categories">'
						. windsor_get_post_categories()
						. $windsor_post_counters_output
						. '</div>' 
					: '')
			. '<h6 class="post_title">' . ($windsor_post_link ? '<a href="' . esc_url($windsor_post_link) . '">' : '') . ($windsor_post_title) . ($windsor_post_link ? '</a>' : '') . '</h6>'
			. apply_filters('windsor_filter_get_post_info', 
								'<div class="post_info">'
									. ($windsor_show_date 
										? '<span class="post_info_item post_info_posted">'
											. ($windsor_post_link ? '<a href="' . esc_url($windsor_post_link) . '" class="post_info_date">' : '') 
											. esc_html($windsor_post_date) 
											. ($windsor_post_link ? '</a>' : '')
											. '</span>'
										: '')
									. ($windsor_show_author 
										? '<span class="post_info_item post_info_posted_by">' 
											. esc_html__('by', 'windsor') . ' ' 
											. ($windsor_post_link ? '<a href="' . esc_url($windsor_post_author_url) . '" class="post_info_author">' : '') 
											. esc_html($windsor_post_author_name) 
											. ($windsor_post_link ? '</a>' : '') 
											. '</span>'
										: '')
									. (!$windsor_show_categories && $windsor_post_counters_output
										? $windsor_post_counters_output
										: '')
								. '</div>')
		. '</div>'
	. '</article>';
windsor_storage_set('windsor_output_widgets_posts', $windsor_output);
?>