<?php
/**
 * Default Theme Options and Internal Theme Settings
 *
 * @package WordPress
 * @subpackage WINDSOR
 * @since WINDSOR 1.0
 */

// Theme init priorities:
// 1 - register filters, that add/remove lists items for the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options
// 9 - register other filters (for installer, etc.)
if (!function_exists('windsor_options_theme_setup2')) {
	add_action( 'after_setup_theme', 'windsor_options_theme_setup2', 2 );
	function windsor_options_theme_setup2() {
		windsor_options_create();
	}
}

// Load default settings and previously saved mods
if (!function_exists('windsor_options_theme_setup5')) {
	add_action( 'after_setup_theme', 'windsor_options_theme_setup5', 5 );
	function windsor_options_theme_setup5() {
		windsor_load_theme_options();
	}
}

// Load current values for each customizable option
if ( !function_exists('windsor_load_theme_options') ) {
	function windsor_load_theme_options() {
		$options = windsor_storage_get('options');
		foreach ($options as $k=>$v) {
			if (isset($v['std'])) {
				if (strpos($v['std'], '$windsor_')!==false) {
					$func = substr($v['std'], 1);
					if (function_exists($func)) {
						$v['std'] = $func($k);
					}
				}
				windsor_storage_set_array2('options', $k, 'val', isset($_GET[$k]) 
					? windsor_get_value_gpc($k)
					: get_theme_mod($k, $v['std'])
					);
			}
		}
		do_action('windsor_action_load_options');
	}
}

// Override options with stored page/post meta
if ( !function_exists('windsor_override_theme_options') ) {
	add_action( 'wp', 'windsor_override_theme_options', 1 );
	function windsor_override_theme_options($query=null) {
		if (is_page_template('blog.php')) {
			windsor_storage_set('blog_archive', true);
			windsor_storage_set('blog_template', get_the_ID());
		}
		windsor_storage_set('blog_mode', windsor_detect_blog_mode());
		if (is_singular()) {
			windsor_storage_set('options_meta', get_post_meta(get_the_ID(), 'windsor_options', true));
		}

		do_action('windsor_action_override_theme_options');
	}
}


// Return customizable option value
if (!function_exists('windsor_get_theme_option')) {
	function windsor_get_theme_option($name, $defa='', $strict_mode=false, $post_id=0) {
		$rez = $defa;
		$from_post_meta = false;
		if ($post_id > 0) {
			if (!windsor_storage_isset('post_options_meta', $post_id))
				windsor_storage_set_array('post_options_meta', $post_id, get_post_meta($post_id, 'windsor_options', true));
			if (windsor_storage_isset('post_options_meta', $post_id, $name)) {
				$tmp = windsor_storage_get_array('post_options_meta', $post_id, $name);
				if (!windsor_is_inherit($tmp)) {
					$rez = $tmp;
					$from_post_meta = true;
				}
			}
		}
		if (!$from_post_meta && windsor_storage_isset('options')) {
			if ( !windsor_storage_isset('options', $name) ) {
				$rez = $tmp = '_not_exists_';
				if (function_exists('trx_addons_get_option'))
					$rez = trx_addons_get_option($name, $tmp, false);
				if ($rez === $tmp) {
					if ($strict_mode) {
						$s = debug_backtrace();
						$s = array_shift($s);
						echo '<pre>' . sprintf(esc_html__('Undefined option "%s" called from:', 'windsor'), $name);
						if (function_exists('dco')) dco($s);
						echo '</pre>';
                        wp_die();
					} else
						$rez = $defa;
				}
			} else {
				$blog_mode = windsor_storage_get('blog_mode');
				// Override option from GET or POST for current blog mode
				if (!empty($blog_mode) && isset($_REQUEST[$name . '_' . $blog_mode])) {
					$rez = windsor_get_value_gpc($name . '_' . $blog_mode);
				// Override option from GET
				} else if (isset($_REQUEST[$name])) {
					$rez = sanitize_text_field($_REQUEST[$name]);
				// Override option from current page settings (if exists)
				} else if (windsor_storage_isset('options_meta', $name) && !windsor_is_inherit(windsor_storage_get_array('options_meta', $name))) {
					$rez = windsor_storage_get_array('options_meta', $name);
				// Override option from current blog mode settings: 'home', 'search', 'page', 'post', 'blog', etc. (if exists)
				} else if (!empty($blog_mode) && windsor_storage_isset('options', $name . '_' . $blog_mode, 'val') && !windsor_is_inherit(windsor_storage_get_array('options', $name . '_' . $blog_mode, 'val'))) {
					$rez = windsor_storage_get_array('options', $name . '_' . $blog_mode, 'val');
				// Get saved option value
				} else if (windsor_storage_isset('options', $name, 'val')) {
					$rez = windsor_storage_get_array('options', $name, 'val');
				// Get WINDSOR_Addons option value
				} else if (function_exists('trx_addons_get_option')) {
					$rez = trx_addons_get_option($name, $defa, false);
				}
			}
		}
		return $rez;
	}
}


// Check if customizable option exists
if (!function_exists('windsor_check_theme_option')) {
	function windsor_check_theme_option($name) {
		return windsor_storage_isset('options', $name);
	}
}

// Get dependencies list from the Theme Options
if ( !function_exists('windsor_get_theme_dependencies') ) {
	function windsor_get_theme_dependencies() {
		$options = windsor_storage_get('options');
		$depends = array();
		foreach ($options as $k=>$v) {
			if (isset($v['dependency'])) 
				$depends[$k] = $v['dependency'];
		}
		return $depends;
	}
}

// Return internal theme setting value
if (!function_exists('windsor_get_theme_setting')) {
	function windsor_get_theme_setting($name) {
		return windsor_storage_isset('settings', $name) ? windsor_storage_get_array('settings', $name) : false;
	}
}


// Set theme setting
if ( !function_exists( 'windsor_set_theme_setting' ) ) {
	function windsor_set_theme_setting($option_name, $value) {
		if (windsor_storage_isset('settings', $option_name))
			windsor_storage_set_array('settings', $option_name, $value);
	}
}


// -----------------------------------------------------------------
// -- ONLY FOR PROGRAMMERS, NOT FOR CUSTOMER
// -- Internal theme settings
// -----------------------------------------------------------------
windsor_storage_set('settings', array(
	
	'custom_sidebars'	=> 8,									// How many custom sidebars will be registered (in addition to theme preset sidebars): 0 - 10

	'ajax_views_counter'=> true,								// Use AJAX for increment posts counter (if cache plugins used) 
																// or increment posts counter then loading page (without cache plugin)
	'breadcrumbs_max_level' 	=> 3,							// Max number of the nested categories in the breadcrumbs (0 - unlimited)

	'use_mediaelements'	=> true,								// Load script "Media Elements" to play video and audio

	'max_excerpt_length'=> 60,									// Max words number for the excerpt in the blog style 'Excerpt'.
																// For style 'Classic' - get half from this value
	'message_maxlength'	=> 1000,								// Max length of the message from contact form
	'comment_after_name' => true,								// Place 'comment' field before the 'name' and 'email'
			
	
	'admin_dummy_timeout' => 1200,								// Timeframe for PHP scripts when import dummy data
	'admin_dummy_style' => 2									// 1 | 2 - Progress bar style when import dummy data
));



// -----------------------------------------------------------------
// -- Theme fonts (Google and/or custom fonts)
// -----------------------------------------------------------------

windsor_storage_set('theme_fonts', array(
	'p' => array(					// Text
		'family'=> '"PT Sans Narrow", sans-serif',
		'link'	=> 'PT+Sans+Narrow:400,700'
		),
	'h1' => array(
		'family'=> '"Antonio", sans-serif',
		'css'   => windsor_get_file_url('/css/font-face/antonio/stylesheet.css')
		),
	'h2' => array(
		'family'=> '"Antonio", sans-serif',
		),
	'h3' => array(
		'family'=> '"Antonio", sans-serif',
		),
	'h4' => array(
		'family'=> '"Antonio", sans-serif',
		),
	'h5' => array(
		'family'=> '"Antonio", sans-serif',
		),
	'h6' => array(
		'family'=> '"Antonio", sans-serif',
		),
	'input' => array(
		'family'=> '"PT Sans Narrow", sans-serif',
		),
	'logo' => array(
		'family'=> '"Antonio", sans-serif',
		),
	'info' => array(
		'family'=> '"TeX Gyre Termes", serif',
		'css'   => windsor_get_file_url('/css/font-face/texgyretermes/stylesheet.css')
		),
	'menu' => array(
		'family'=> '"Antonio", sans-serif',
		),
	'submenu' => array(
		'family'=> '"Antonio", sans-serif',
		)
));


// -----------------------------------------------------------------
// -- Theme colors for customizer
// -- Attention! Inner scheme must be last in the array below
// -----------------------------------------------------------------
windsor_storage_set('schemes', array(

	// Color scheme: 'default'
	'default' => array(
		'title'	 => esc_html__('Default', 'windsor'),
		'colors' => array(
			
			// Whole block border and background
			'bg_color'				=> '#ffffff',
			'bd_color'				=> '#e7eef2',

			// Text and links colors
			'text'					=> '#3f4346',
			'text_light'			=> '#a0b2be',
			'text_dark'				=> '#13162b',
			'text_link'				=> '#3fb9be',
			'text_hover'			=> '#13162b',

			// Alternative blocks (submenu, buttons, tabs, etc.)
			'alter_bg_color'		=> '#e7eef2',
			'alter_bg_hover'		=> '#dae1e5',
			'alter_bd_color'		=> '#dae1e5',
			'alter_bd_hover'		=> '#ced5d9',
			'alter_text'			=> '#3f4346',
			'alter_light'			=> '#a0b2be',
			'alter_dark'			=> '#13162b',
			'alter_link'			=> '#3fb9be',
			'alter_hover'			=> '#13162b',

			// Input fields (form's fields and textarea)
			'input_bg_color'		=> '#f4f9fc',
			'input_bg_hover'		=> '#ebf4fa',
			'input_bd_color'		=> '#f4f9fc',
			'input_bd_hover'		=> '#dae9f2',
			'input_text'			=> '#a0b2be',
			'input_light'			=> '#8b9ba6',
			'input_dark'			=> '#76838c',
			
			// Inverse blocks (text and links on accented bg)
			'inverse_text'			=> '#f0f0f0',
			'inverse_light'			=> '#f7f7f7',
			'inverse_dark'			=> '#ffffff',
			'inverse_link'			=> '#ffffff',
			'inverse_hover'			=> '#13162b',
		
		)
	),

	// Color scheme: 'light'
	'light' => array(
		'title'	 => esc_html__('Light', 'windsor'),
		'colors' => array(
			
			// Whole block border and background
			'bg_color'				=> '#e7eef2',
			'bd_color'				=> '#dae1e5',

			// Text and links colors
			'text'					=> '#3f4346',
			'text_light'			=> '#a0b2be',
			'text_dark'				=> '#13162b',
			'text_link'				=> '#3fb9be',
			'text_hover'			=> '#13162b',

			// Alternative blocks (submenu, buttons, tabs, etc.)
			'alter_bg_color'		=> '#ffffff',
			'alter_bg_hover'		=> '#f7f7f7',
			'alter_bd_color'		=> '#f0f0f0',
			'alter_bd_hover'		=> '#e0e0e0',
			'alter_text'			=> '#3f4346',
			'alter_light'			=> '#a0b2be',
			'alter_dark'			=> '#13162b',
			'alter_link'			=> '#3fb9be',
			'alter_hover'			=> '#13162b',

			// Input fields (form's fields and textarea)
			'input_bg_color'		=> '#f4f9fc',
			'input_bg_hover'		=> '#ebf4fa',
			'input_bd_color'		=> '#f4f9fc',
			'input_bd_hover'		=> '#dae9f2',
			'input_text'			=> '#a0b2be',
			'input_light'			=> '#b6cad9',
			'input_dark'			=> '#8b9ba6',
			
			// Inverse blocks (text and links on accented bg)
			'inverse_text'			=> '#f0f0f0',
			'inverse_light'			=> '#f7f7f7',
			'inverse_dark'			=> '#ffffff',
			'inverse_link'			=> '#ffffff',
			'inverse_hover'			=> '#13162b',

		)
	),

	// Color scheme: 'side'
	'side' => array(
		'title'  => esc_html__('Side', 'windsor'),
		'colors' => array(
			
			// Whole block border and background
			'bg_color'				=> '#0d101f',
			'bd_color'				=> '#2b2e41',

			// Text and links colors
			'text'					=> '#969fa6',
			'text_light'			=> '#b8c3cc',
			'text_dark'				=> '#ffffff',
			'text_link'				=> '#3fb9be',
			'text_hover'			=> '#ffffff',

			// Alternative blocks (submenu, buttons, tabs, etc.)
			'alter_bg_color'		=> '#13162b',
			'alter_bg_hover'		=> '#1a1e3b',
			'alter_bd_color'		=> '#2b2e41',
			'alter_bd_hover'		=> '#32364d',
			'alter_text'			=> '#969fa6',
			'alter_light'			=> '#b8c3cc',
			'alter_dark'			=> '#ffffff',
			'alter_link'			=> '#3fb9be',
			'alter_hover'			=> '#ffffff',

			// Input fields (form's fields and textarea)
			'input_bg_color'		=> '#13162b',
			'input_bg_hover'		=> '#1a1e3b',
			'input_bd_color'		=> '#1a1e3b',
			'input_bd_hover'		=> '#1a1e3b',
			'input_text'			=> '#969fa6',
			'input_light'			=> '#b8c3cc',
			'input_dark'			=> '#ffffff',
			
			// Inverse blocks (text and links on accented bg)
			'inverse_text'			=> '#f0f0f0',
			'inverse_light'			=> '#f7f7f7',
			'inverse_dark'			=> '#ffffff',
			'inverse_link'			=> '#ffffff',
			'inverse_hover'			=> '#13162b',

		)
	),

	// Color scheme: 'dark'
	'dark' => array(
		'title'  => esc_html__('Dark', 'windsor'),
		'colors' => array(
			
			// Whole block border and background
			'bg_color'				=> '#070811',
			'bd_color'				=> '#2b2e41',

			// Text and links colors
			'text'					=> '#969fa6',
			'text_light'			=> '#b8c3cc',
			'text_dark'				=> '#ffffff',
			'text_link'				=> '#3fb9be',
			'text_hover'			=> '#ffffff',

			// Alternative blocks (submenu, buttons, tabs, etc.)
			'alter_bg_color'		=> '#0e1123',
			'alter_bg_hover'		=> '#181e3d',
			'alter_bd_color'		=> '#181e3d',
			'alter_bd_hover'		=> '#1f254d',
			'alter_text'			=> '#969fa6',
			'alter_light'			=> '#b8c3cc',
			'alter_dark'			=> '#ffffff',
			'alter_link'			=> '#3fb9be',
			'alter_hover'			=> '#ffffff',

			// Input fields (form's fields and textarea)
			'input_bg_color'		=> '#0e1123',
			'input_bg_hover'		=> '#181e3d',
			'input_bd_color'		=> '#181e3d',
			'input_bd_hover'		=> '#181e3d',
			'input_text'			=> '#969fa6',
			'input_light'			=> '#b8c3cc',
			'input_dark'			=> '#ffffff',
			
			// Inverse blocks (text and links on accented bg)
			'inverse_text'			=> '#f0f0f0',
			'inverse_light'			=> '#f7f7f7',
			'inverse_dark'			=> '#ffffff',
			'inverse_link'			=> '#ffffff',
			'inverse_hover'			=> '#13162b',

		)
	),

	// Color scheme: 'brown'
	'brown' => array(
		'title'	 => esc_html__('Brown', 'windsor'),
		'colors' => array(

			// Whole block border and background
			'bg_color'				=> '#ffffff', //
			'bd_color'				=> '#f7f7f7',

			// Text and links colors
			'text'					=> '#55504b', //
			'text_light'			=> '#a88c5c', //
			'text_dark'				=> '#34271c', //
			'text_link'				=> '#a88c5c', //
			'text_hover'			=> '#13162b',

			// Alternative blocks (submenu, buttons, tabs, etc.)
			'alter_bg_color'		=> '#f7f7f7', //
			'alter_bg_hover'		=> '#f7f7f7',
			'alter_bd_color'		=> '#e9ecee', //
			'alter_bd_hover'		=> '#ced5d9',
			'alter_text'			=> '#3f4346',
			'alter_light'			=> '#afa7a1', //
			'alter_dark'			=> '#13162b',
			'alter_link'			=> '#a88c5c',
			'alter_hover'			=> '#13162b',

			// Input fields (form's fields and textarea)
			'input_bg_color'		=> '#f4f9fc',
			'input_bg_hover'		=> '#ebf4fa',
			'input_bd_color'		=> '#f4f9fc',
			'input_bd_hover'		=> '#C7BFB9',
			'input_text'			=> '#afa7a1', //
			'input_light'			=> '#8b9ba6',
			'input_dark'			=> '#76838c',

			// Inverse blocks (text and links on accented bg)
			'inverse_text'			=> '#f0f0f0',
			'inverse_light'			=> '#f7f7f7',
			'inverse_dark'			=> '#ffffff', //
			'inverse_link'			=> '#ffffff',
			'inverse_hover'			=> '#13162b',

		)
	),


	// Color scheme: 'brown'
	'brown_dark' => array(
		'title'	 => esc_html__('Brown Dark', 'windsor'),
		'colors' => array(

			// Whole block border and background
			'bg_color'				=> '#1d1006', //
			'bd_color'				=> '#f7f7f7',

			// Text and links colors
			'text'					=> '#55504b',
			'text_light'			=> '#a88c5c',
			'text_dark'				=> '#ffffff', //
			'text_link'				=> '#a88c5c',
			'text_hover'			=> '#13162b',

			// Alternative blocks (submenu, buttons, tabs, etc.)
			'alter_bg_color'		=> '#e7eef2',
			'alter_bg_hover'		=> '#e7eef2',
			'alter_bd_color'		=> '#e7eef2',
			'alter_bd_hover'		=> '#ced5d9',
			'alter_text'			=> '#a88c5c', //
			'alter_light'			=> '#a0b2be',
			'alter_dark'			=> '#ffffff', //
			'alter_link'			=> '#a88c5c',
			'alter_hover'			=> '#13162b',

			// Input fields (form's fields and textarea)
			'input_bg_color'		=> '#1d1006', //
			'input_bg_hover'		=> '#ebf4fa',
			'input_bd_color'		=> '#51443a', //
			'input_bd_hover'		=> '#51443a',
			'input_text'			=> '#736c66', //
			'input_light'			=> '#736c66',
			'input_dark'			=> '#736c66',

			// Inverse blocks (text and links on accented bg)
			'inverse_text'			=> '#f0f0f0',
			'inverse_light'			=> '#f7f7f7',
			'inverse_dark'			=> '#ffffff',
			'inverse_link'			=> '#ffffff',
			'inverse_hover'			=> '#13162b',

		)
	),
	// Color scheme: 'brown'
	'brown_light' => array(
		'title'	 => esc_html__('Brown Light', 'windsor'),
		'colors' => array(

			// Whole block border and background
			'bg_color'				=> '#3e3024',
			'bd_color'				=> '#ffffff',

			// Text and links colors
			'text'					=> '#8c8986', //
			'text_light'			=> '#a88c5c',
			'text_dark'				=> '#ffffff', //
			'text_link'				=> '#a88c5c', //
			'text_hover'			=> '#13162b',

			// Alternative blocks (submenu, buttons, tabs, etc.)
			'alter_bg_color'		=> '#3e3024', //
			'alter_bg_hover'		=> '#ffffff',
			'alter_bd_color'		=> '#ffffff',
			'alter_bd_hover'		=> '#ced5d9',
			'alter_text'			=> '#3f4346',
			'alter_light'			=> '#a0b2be',
			'alter_dark'			=> '#13162b',
			'alter_link'			=> '#a88c5c',
			'alter_hover'			=> '#13162b',

			// Input fields (form's fields and textarea)
			'input_bg_color'		=> '#3e3024', //
			'input_bg_hover'		=> '#ebf4fa',
			'input_bd_color'		=> '#51443a', //
			'input_bd_hover'		=> '#51443a',
			'input_text'			=> '#736c66', //
			'input_light'			=> '#736c66',
			'input_dark'			=> '#736c66',

			// Inverse blocks (text and links on accented bg)
			'inverse_text'			=> '#f0f0f0',
			'inverse_light'			=> '#f7f7f7',
			'inverse_dark'			=> '#ffffff',
			'inverse_link'			=> '#ffffff',
			'inverse_hover'			=> '#13162b',

		)
	),

	// Color scheme: 'brown_side'
	'brown_side' => array(
		'title'  => esc_html__('Brown Side', 'windsor'),
		'colors' => array(

			// Whole block border and background
			'bg_color'				=> '#27180d',//
			'bd_color'				=> '#3d3026',

			// Text and links colors
			'text'					=> '#969fa6',
			'text_light'			=> '#b8c3cc',
			'text_dark'				=> '#ffffff',
			'text_link'				=> '#a88c5c',
			'text_hover'			=> '#ffffff',

			// Alternative blocks (submenu, buttons, tabs, etc.)
			'alter_bg_color'		=> '#13162b',
			'alter_bg_hover'		=> '#1a1e3b',
			'alter_bd_color'		=> '#2b2e41',
			'alter_bd_hover'		=> '#32364d',
			'alter_text'			=> '#969fa6',
			'alter_light'			=> '#b8c3cc',
			'alter_dark'			=> '#ffffff',
			'alter_link'			=> '#a88c5c',
			'alter_hover'			=> '#ffffff',

			// Input fields (form's fields and textarea)
			'input_bg_color'		=> '#13162b',
			'input_bg_hover'		=> '#1a1e3b',
			'input_bd_color'		=> '#1a1e3b',
			'input_bd_hover'		=> '#1a1e3b',
			'input_text'			=> '#969fa6',
			'input_light'			=> '#b8c3cc',
			'input_dark'			=> '#ffffff',

			// Inverse blocks (text and links on accented bg)
			'inverse_text'			=> '#f0f0f0',
			'inverse_light'			=> '#f7f7f7',
			'inverse_dark'			=> '#ffffff',
			'inverse_link'			=> '#ffffff',
			'inverse_hover'			=> '#13162b',
		)
	),

));



// -----------------------------------------------------------------
// -- Theme options for customizer
// -----------------------------------------------------------------
if (!function_exists('windsor_options_create')) {

	function windsor_options_create() {

		windsor_storage_set('options', array(
		
			// Section 'Title & Tagline' - add theme options in the standard WP section
			'title_tagline' => array(
				"title" => esc_html__('Title, Tagline & Site icon', 'windsor'),
				"desc" => wp_kses_data( __('Specify site title and tagline (if need) and upload the site icon', 'windsor') ),
				"type" => "section"
				),
		
		
			// Section 'Header' - add theme options in the standard WP section
			'header_image' => array(
				"title" => esc_html__('Header', 'windsor'),
				"desc" => wp_kses_data( __('Select or upload logo images, select header type and widgets set for the header', 'windsor') ),
				"type" => "section"
				),
			'header_image_override' => array(
				"title" => esc_html__('Header image override', 'windsor'),
				"desc" => wp_kses_data( __("Allow override the header image with the page's/post's/product's/etc. featured image", 'windsor') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'windsor')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'header_video' => array(
				"title" => esc_html__('Header video', 'windsor'),
				"desc" => wp_kses_data( __("Select video to use it as background for the header", 'windsor') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'windsor')
				),
				"std" => '',
				"type" => "video"
				),
			'header_fullheight' => array(
				"title" => esc_html__('Fullheight Header', 'windsor'),
				"desc" => wp_kses_data( __("Enlarge header area to fill whole screen. Used only if header have a background image", 'windsor') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'windsor')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'header_style' => array(
				"title" => esc_html__('Header style', 'windsor'),
				"desc" => wp_kses_data( __('Select style to display the site header', 'windsor') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'windsor')
				),
				"std" => 'header-1',
				"options" => windsor_get_list_header_styles(),
				"type" => "select"
				),
			'header_position' => array(
				"title" => esc_html__('Header position', 'windsor'),
				"desc" => wp_kses_data( __('Select position to display the site header', 'windsor') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'windsor')
				),
				"std" => 'default',
				"options" => windsor_get_list_header_positions(),
				"type" => "select"
				),
			'header_scheme' => array(
				"title" => esc_html__('Header Color Scheme', 'windsor'),
				"desc" => wp_kses_data( __('Select color scheme to decorate header area', 'windsor') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'windsor')
				),
				"std" => 'inherit',
				"options" => windsor_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'menu_style' => array(
				"title" => esc_html__('Menu position', 'windsor'),
				"desc" => wp_kses_data( __('Select position of the main menu', 'windsor') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'windsor')
				),
				"std" => 'top',
				"options" => windsor_get_list_menu_positions(),
				"type" => "switch"
				),
			'menu_scheme' => array(
				"title" => esc_html__('Menu Color Scheme', 'windsor'),
				"desc" => wp_kses_data( __('Select color scheme to decorate main menu area', 'windsor') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'windsor')
				),
				"std" => 'inherit',
				"options" => windsor_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'menu_cache' => array(
				"title" => esc_html__('Use menu cache', 'windsor'),
				"desc" => wp_kses_data( __('Use cache for the menu (increase theme speed, decrease queries number). Attention! Please, save menu again after change permalink settings!', 'windsor') ),
				"std" => 1,
				"type" => "checkbox"
				),
			'menu_stretch' => array(
				"title" => esc_html__('Stretch sidemenu', 'windsor'),
				"desc" => wp_kses_data( __('Stretch sidemenu to window height (if menu items number >= 5)', 'windsor') ),
				"std" => 1,
				"type" => "checkbox"
				),
			'search_style' => array(
				"title" => esc_html__('Search in the header', 'windsor'),
				"desc" => wp_kses_data( __('Select style of the search field in the header', 'windsor') ),
				"std" => 'expand',
				"options" => array(
					'expand' => esc_html__('Expand', 'windsor'),
					'fullscreen' => esc_html__('Fullscreen', 'windsor')
				),
				"type" => "switch"
				),
			'header_widgets' => array(
				"title" => esc_html__('Header widgets', 'windsor'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on each page', 'windsor') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'windsor'),
					"desc" => wp_kses_data( __('Select set of widgets to show in the header on this page', 'windsor') ),
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
				"type" => "select"
				),
			'header_columns' => array(
				"title" => esc_html__('Header columns', 'windsor'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the Header. If 0 - autodetect by the widgets count', 'windsor') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'windsor')
				),
				"dependency" => array(
					'header_widgets' => array('^hide')
				),
				"std" => 0,
				"options" => windsor_get_list_range(0,6),
				"type" => "select"
				),
			'header_wide' => array(
				"title" => esc_html__('Header fullwide', 'windsor'),
				"desc" => wp_kses_data( __('Do you want to stretch the header widgets area to the entire window width?', 'windsor') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'windsor')
				),
				"std" => 1,
				"type" => "checkbox"
				),
			'show_page_title' => array(
				"title" => esc_html__('Show Page Title', 'windsor'),
				"desc" => wp_kses_data( __('Do you want to show page title area (page/post/category title and breadcrumbs)?', 'windsor') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'windsor')
				),
				"std" => 1,
				"type" => "checkbox"
				),
			'show_breadcrumbs' => array(
				"title" => esc_html__('Show breadcrumbs', 'windsor'),
				"desc" => wp_kses_data( __('Do you want to show breadcrumbs in the page title area?', 'windsor') ),
				"std" => 0,
				"type" => "checkbox"
				),
			'logo' => array(
				"title" => esc_html__('Logo', 'windsor'),
				"desc" => wp_kses_data( __('Select or upload site logo', 'windsor') ),
				"std" => '',
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'windsor')
				),
				"type" => "image"
				),
			'logo_retina' => array(
				"title" => esc_html__('Logo for Retina', 'windsor'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'windsor') ),
				"std" => '',
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'windsor')
				),
				"type" => "image"
				),
			'header_title_image' => array(
				"title" => esc_html__('Header title image', 'windsor'),
				"desc" => wp_kses_data( __('Select image to insert into the Header "Style 2"', 'windsor') ),
				"std" => '',
				"type" => "image"
				),
			'header_title_text' => array(
				"title" => esc_html__('Header title text', 'windsor'),
				"desc" => wp_kses_data( __('Put here text to insert into the Header "Style 2"', 'windsor') ),
				"std" => '',
				"type" => "textarea"
				),
			'mobile_layout_width' => array(
				"title" => esc_html__('Mobile layout from', 'windsor'),
				"desc" => wp_kses_data( __('Window width to show mobile layout of the header', 'windsor') ),
				"std" => 959,
				"type" => "text"
				),
			
		
		
			// Section 'Content'
			'content' => array(
				"title" => esc_html__('Content', 'windsor'),
				"desc" => wp_kses_data( __('Options for the content area', 'windsor') ),
				"type" => "section",
				),
			'body_style' => array(
				"title" => esc_html__('Body style', 'windsor'),
				"desc" => wp_kses_data( __('Select width of the body content', 'windsor') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses',
					'section' => esc_html__('Content', 'windsor')
				),
				"refresh" => false,
				"std" => 'wide',
				"options" => windsor_get_list_body_styles(),
				"type" => "select"
				),
			'color_scheme' => array(
				"title" => esc_html__('Site Color Scheme', 'windsor'),
				"desc" => wp_kses_data( __('Select color scheme to decorate whole site. Attention! Case "Inherit" can be used only for custom pages, not for root site content in the Appearance - Customize', 'windsor') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'windsor')
				),
				"std" => 'default',
				"options" => windsor_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'expand_content' => array(
				"title" => esc_html__('Expand content', 'windsor'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'windsor') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses',
					'section' => esc_html__('Content', 'windsor')
				),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),
			'remove_margins' => array(
				"title" => esc_html__('Remove margins', 'windsor'),
				"desc" => wp_kses_data( __('Remove margins above and below the content area', 'windsor') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses',
					'section' => esc_html__('Content', 'windsor')
				),
				"refresh" => false,
				"std" => 0,
				"type" => "checkbox"
				),
			'seo_snippets' => array(
				"title" => esc_html__('SEO snippets', 'windsor'),
				"desc" => wp_kses_data( __('Add structured data markup to the single posts and pages', 'windsor') ),
				"std" => 0,
				"type" => "checkbox"
				),
            'privacy_text' => array(
                "title" => esc_html__("Text with Privacy Policy link", 'windsor'),
                "desc"  => wp_kses_data( __("Specify text with Privacy Policy link for the checkbox 'I agree ...'", 'windsor') ),
                "std"   => wp_kses( __( 'I agree that my submitted data is being collected and stored.', 'windsor'), 'windsor_kses_content' ),
                "type"  => "text"
            ),
			'no_image' => array(
				"title" => esc_html__('No image placeholder', 'windsor'),
				"desc" => wp_kses_data( __('Select or upload image, used as placeholder for the posts without featured image', 'windsor') ),
				"std" => '',
				"type" => "image"
				),
			'sidebar_widgets' => array(
				"title" => esc_html__('Sidebar widgets', 'windsor'),
				"desc" => wp_kses_data( __('Select default widgets to show in the sidebar', 'windsor') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses',
					'section' => esc_html__('Widgets', 'windsor')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_scheme' => array(
				"title" => esc_html__('Color Scheme', 'windsor'),
				"desc" => wp_kses_data( __('Select color scheme to decorate sidebar', 'windsor') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses',
					'section' => esc_html__('Widgets', 'windsor')
				),
				"std" => 'side',
				"options" => windsor_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'sidebar_position' => array(
				"title" => esc_html__('Sidebar position', 'windsor'),
				"desc" => wp_kses_data( __('Select position to show sidebar', 'windsor') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses',
					'section' => esc_html__('Widgets', 'windsor')
				),
				"refresh" => false,
				"std" => 'right',
				"options" => windsor_get_list_sidebars_positions(),
				"type" => "select"
				),
			'widgets_above_page' => array(
				"title" => esc_html__('Widgets above the page', 'windsor'),
				"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'windsor') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'windsor')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_above_content' => array(
				"title" => esc_html__('Widgets above the content', 'windsor'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'windsor') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'windsor')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_content' => array(
				"title" => esc_html__('Widgets below the content', 'windsor'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'windsor') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'windsor')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_page' => array(
				"title" => esc_html__('Widgets below the page', 'windsor'),
				"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'windsor') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'windsor')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
				"type" => "select"
				),
		
		
		
			// Section 'Footer'
			'footer' => array(
				"title" => esc_html__('Footer', 'windsor'),
				"desc" => wp_kses_data( __('Select set of widgets and columns number for the site footer', 'windsor') ),
				"type" => "section"
				),
			'footer_scheme' => array(
				"title" => esc_html__('Footer Color Scheme', 'windsor'),
				"desc" => wp_kses_data( __('Select color scheme to decorate footer area', 'windsor') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses',
					'section' => esc_html__('Footer', 'windsor')
				),
				"std" => 'dark',
				"options" => windsor_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'footer_widgets' => array(
				"title" => esc_html__('Footer widgets', 'windsor'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the footer', 'windsor') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses',
					'section' => esc_html__('Footer', 'windsor')
				),
				"std" => 'footer_widgets',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
				"type" => "select"
				),
			'footer_columns' => array(
				"title" => esc_html__('Footer columns', 'windsor'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'windsor') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses',
					'section' => esc_html__('Footer', 'windsor')
				),
				"dependency" => array(
					'footer_widgets' => array('^hide')
				),
				"std" => 3,
				"options" => windsor_get_list_range(0,6),
				"type" => "select"
				),
			'footer_wide' => array(
				"title" => esc_html__('Footer fullwide', 'windsor'),
				"desc" => wp_kses_data( __('Do you want to stretch the footer to the entire window width?', 'windsor') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses',
					'section' => esc_html__('Footer', 'windsor')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_in_footer' => array(
				"title" => esc_html__('Show logo', 'windsor'),
				"desc" => wp_kses_data( __('Show logo in the footer', 'windsor') ),
				'refresh' => false,
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_footer' => array(
				"title" => esc_html__('Logo for footer', 'windsor'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the footer', 'windsor') ),
				"dependency" => array(
					'logo_in_footer' => array('1')
				),
				"std" => '',
				"type" => "image"
				),
			'logo_footer_retina' => array(
				"title" => esc_html__('Logo for footer (Retina)', 'windsor'),
				"desc" => wp_kses_data( __('Select or upload logo for the footer area used on Retina displays (if empty - use default logo from the field above)', 'windsor') ),
				"dependency" => array(
					'logo_in_footer' => array('1')
				),
				"std" => '',
				"type" => "image"
				),
			'socials_in_footer' => array(
				"title" => esc_html__('Show social icons', 'windsor'),
				"desc" => wp_kses_data( __('Show social icons in the footer (under logo or footer widgets)', 'windsor') ),
				"std" => 0,
				"type" => "checkbox"
				),
			'copyright' => array(
				"title" => esc_html__('Copyright', 'windsor'),
				"desc" => wp_kses_data( __('Copyright text in the footer', 'windsor') ),
				"std" => esc_html__('ThemeREX &copy; {Y}. All rights reserved.', 'windsor'),
				"refresh" => false,
				"type" => "textarea"
				),
		
		
		
			// Section 'Homepage' - settings for home page
			'homepage' => array(
				"title" => esc_html__('Homepage', 'windsor'),
				"desc" => wp_kses_data( __('Select blog style and widgets to display on the homepage', 'windsor') ),
				"type" => "section"
				),
			'expand_content_home' => array(
				"title" => esc_html__('Expand content', 'windsor'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden on the Homepage', 'windsor') ),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),
			'blog_style_home' => array(
				"title" => esc_html__('Blog style', 'windsor'),
				"desc" => wp_kses_data( __('Select posts style for the homepage', 'windsor') ),
				"std" => 'excerpt',
				"options" => windsor_get_list_blog_styles(),
				"type" => "select"
				),
			'first_post_large_home' => array(
				"title" => esc_html__('First post large', 'windsor'),
				"desc" => wp_kses_data( __('Make first post large (with Excerpt layout) on the Classic layout of the Homepage', 'windsor') ),
				"dependency" => array(
					'blog_style_home' => array('classic')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'header_widgets_home' => array(
				"title" => esc_html__('Header widgets', 'windsor'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on the homepage', 'windsor') ),
				"std" => 'header_widgets',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_widgets_home' => array(
				"title" => esc_html__('Sidebar widgets', 'windsor'),
				"desc" => wp_kses_data( __('Select sidebar to show on the homepage', 'windsor') ),
				"std" => 'sidebar_widgets',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_position_home' => array(
				"title" => esc_html__('Sidebar position', 'windsor'),
				"desc" => wp_kses_data( __('Select position to show sidebar on the homepage', 'windsor') ),
				"refresh" => false,
				"std" => 'right',
				"options" => windsor_get_list_sidebars_positions(),
				"type" => "select"
				),
			'widgets_above_page_home' => array(
				"title" => esc_html__('Widgets above the page', 'windsor'),
				"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'windsor') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_above_content_home' => array(
				"title" => esc_html__('Widgets above the content', 'windsor'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'windsor') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_content_home' => array(
				"title" => esc_html__('Widgets below the content', 'windsor'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'windsor') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_page_home' => array(
				"title" => esc_html__('Widgets below the page', 'windsor'),
				"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'windsor') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
				"type" => "select"
				),
			
		
		
			// Section 'Blog archive'
			'blog' => array(
				"title" => esc_html__('Blog archive', 'windsor'),
				"desc" => wp_kses_data( __('Options for the blog archive', 'windsor') ),
				"type" => "section",
				),
			'expand_content_blog' => array(
				"title" => esc_html__('Expand content', 'windsor'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden on the blog archive', 'windsor') ),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),
			'blog_style' => array(
				"title" => esc_html__('Blog style', 'windsor'),
				"desc" => wp_kses_data( __('Select posts style for the blog archive', 'windsor') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'windsor')
				),
				"dependency" => array(
                    '#page_template' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"std" => 'excerpt',
				"options" => windsor_get_list_blog_styles(),
				"type" => "select"
				),
			'parent_cat' => array(
				"title" => esc_html__('Category to show', 'windsor'),
				"desc" => wp_kses_data( __('Select category to show in the blog archive', 'windsor') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'windsor')
				),
				"dependency" => array(
                    '#page_template' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"std" => '0',
				"options" => windsor_array_merge(array(0 => esc_html__('- Select category -', 'windsor')), windsor_get_list_categories()),
				"type" => "select"
				),
			'posts_per_page' => array(
				"title" => esc_html__('Posts per page', 'windsor'),
				"desc" => wp_kses_data( __('How many posts will be displayed on this page', 'windsor') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'windsor')
				),
				"dependency" => array(
                    '#page_template' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"hidden" => true,
				"std" => '10',
				"type" => "text"
				),
			"blog_pagination" => array( 
				"title" => esc_html__('Pagination style', 'windsor'),
				"desc" => wp_kses_data( __('Show Older/Newest posts or Page numbers below the posts list', 'windsor') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'windsor')
				),
				"std" => "pages",
				"options" => windsor_get_list_paginations(),
				"type" => "select"
				),
			'show_filters' => array(
				"title" => esc_html__('Show filters', 'windsor'),
				"desc" => wp_kses_data( __('Show categories as tabs to filter posts', 'windsor') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'windsor')
				),
				"dependency" => array(
                    '#page_template' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
					'blog_style' => array('portfolio', 'gallery')
				),
				"hidden" => true,
				"std" => 0,
				"type" => "checkbox"
				),
			'first_post_large' => array(
				"title" => esc_html__('First post large', 'windsor'),
				"desc" => wp_kses_data( __('Make first post large (with Excerpt layout) on the Classic layout of blog archive', 'windsor') ),
				"dependency" => array(
					'blog_style' => array('classic')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			"blog_content" => array( 
				"title" => esc_html__('Posts content', 'windsor'),
				"desc" => wp_kses_data( __("Show full post's content in the blog or only post's excerpt", 'windsor') ),
				"std" => "excerpt",
				"options" => windsor_get_list_blog_content(),
				"type" => "select"
				),
			'time_diff_before' => array(
				"title" => esc_html__('Time difference', 'windsor'),
				"desc" => wp_kses_data( __("How many days show time difference instead post's date", 'windsor') ),
				"std" => 5,
				"type" => "text"
				),
			"blog_animation" => array( 
				"title" => esc_html__('Animation for posts', 'windsor'),
				"desc" => wp_kses_data( __('Select animation to show posts in the blog. Attention! Do not use any animation on pages with the "wheel to the anchor" behaviour (like a "Chess 2 columns")!', 'windsor') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'windsor')
				),
				"dependency" => array(
                    '#page_template' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"std" => "none",
				"options" => windsor_get_list_animations_in(),
				"type" => "select"
				),
			"animation_on_mobile" => array( 
				"title" => esc_html__('Allow animation on mobile', 'windsor'),
				"desc" => wp_kses_data( __('Allow extended animation effects on mobile devices', 'windsor') ),
				"std" => 'yes',
				"dependency" => array(
					'blog_animation' => array('^none')
				),
				"options" => windsor_get_list_yesno(),
				"type" => "switch"
				),
			'header_widgets_blog' => array(
				"title" => esc_html__('Header widgets', 'windsor'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on the blog archive', 'windsor') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_widgets_blog' => array(
				"title" => esc_html__('Sidebar widgets', 'windsor'),
				"desc" => wp_kses_data( __('Select sidebar to show on the blog archive', 'windsor') ),
				"std" => 'sidebar_widgets',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_position_blog' => array(
				"title" => esc_html__('Sidebar position', 'windsor'),
				"desc" => wp_kses_data( __('Select position to show sidebar on the blog archive', 'windsor') ),
				"refresh" => false,
				"std" => 'right',
				"options" => windsor_get_list_sidebars_positions(),
				"type" => "select"
				),
			'widgets_above_page_blog' => array(
				"title" => esc_html__('Widgets above the page', 'windsor'),
				"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'windsor') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_above_content_blog' => array(
				"title" => esc_html__('Widgets above the content', 'windsor'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'windsor') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_content_blog' => array(
				"title" => esc_html__('Widgets below the content', 'windsor'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'windsor') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_page_blog' => array(
				"title" => esc_html__('Widgets below the page', 'windsor'),
				"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'windsor') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'windsor')), windsor_get_list_sidebars()),
				"type" => "select"
				),
			
		
		
		
			// Section 'Colors' - choose color scheme and customize separate colors from it
			'scheme' => array(
				"title" => esc_html__('Color scheme editor', 'windsor'),
				"desc" => wp_kses_data( __("<b>Simple settings</b> - you can change only accented color, used for links, buttons and some accented areas.", 'windsor') )
						. '<br>'
						. wp_kses_data( __("<b>Advanced settings</b> - change all scheme's colors and get full control over the appearance of your site!", 'windsor') ),
				"priority" => 1000,
				"type" => "section"
				),
		
			'color_settings' => array(
				"title" => esc_html__('Color settings', 'windsor'),
				"desc" => '',
				"std" => 'simple',
				"options" => windsor_get_list_user_skills(),
				"refresh" => false,
				"type" => "switch"
				),
		
			'color_scheme_editor' => array(
				"title" => esc_html__('Color Scheme', 'windsor'),
				"desc" => wp_kses_data( __('Select color scheme to edit colors', 'windsor') ),
				"std" => 'default',
				"options" => windsor_get_list_schemes(),
				"refresh" => false,
				"type" => "select"
				),
		
			'scheme_storage' => array(
				"title" => esc_html__('Colors storage', 'windsor'),
				"desc" => esc_html__('Hidden storage of the all color from the all color shemes (only for internal usage)', 'windsor'),
				"std" => '',
				"refresh" => false,
				"type" => "hidden"
				),
		
			'scheme_info_single' => array(
				"title" => esc_html__('Colors for single post/page', 'windsor'),
				"desc" => wp_kses_data( __('Specify colors for single post/page (not for alter blocks)', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
				
			'bg_color' => array(
				"title" => esc_html__('Background color', 'windsor'),
				"desc" => wp_kses_data( __('Background color of the whole page', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'bd_color' => array(
				"title" => esc_html__('Border color', 'windsor'),
				"desc" => wp_kses_data( __('Color of the bordered elements, separators, etc.', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'text' => array(
				"title" => esc_html__('Text', 'windsor'),
				"desc" => wp_kses_data( __('Plain text color on single page/post', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_light' => array(
				"title" => esc_html__('Light text', 'windsor'),
				"desc" => wp_kses_data( __('Color of the post meta: post date and author, comments number, etc.', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_dark' => array(
				"title" => esc_html__('Dark text', 'windsor'),
				"desc" => wp_kses_data( __('Color of the headers, strong text, etc.', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_link' => array(
				"title" => esc_html__('Links', 'windsor'),
				"desc" => wp_kses_data( __('Color of links and accented areas', 'windsor') ),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_hover' => array(
				"title" => esc_html__('Links hover', 'windsor'),
				"desc" => wp_kses_data( __('Hover color for links and accented areas', 'windsor') ),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'scheme_info_alter' => array(
				"title" => esc_html__('Colors for alternative blocks', 'windsor'),
				"desc" => wp_kses_data( __('Specify colors for alternative blocks - rectangular blocks with its own background color (posts in homepage, blog archive, search results, widgets on sidebar, footer, etc.)', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
		
			'alter_bg_color' => array(
				"title" => esc_html__('Alter background color', 'windsor'),
				"desc" => wp_kses_data( __('Background color of the alternative blocks', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_bg_hover' => array(
				"title" => esc_html__('Alter hovered background color', 'windsor'),
				"desc" => wp_kses_data( __('Background color for the hovered state of the alternative blocks', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_bd_color' => array(
				"title" => esc_html__('Alternative border color', 'windsor'),
				"desc" => wp_kses_data( __('Border color of the alternative blocks', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_bd_hover' => array(
				"title" => esc_html__('Alternative hovered border color', 'windsor'),
				"desc" => wp_kses_data( __('Border color for the hovered state of the alter blocks', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_text' => array(
				"title" => esc_html__('Alter text', 'windsor'),
				"desc" => wp_kses_data( __('Text color of the alternative blocks', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_light' => array(
				"title" => esc_html__('Alter light', 'windsor'),
				"desc" => wp_kses_data( __('Color of the info blocks inside block with alternative background', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_dark' => array(
				"title" => esc_html__('Alter dark', 'windsor'),
				"desc" => wp_kses_data( __('Color of the headers inside block with alternative background', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_link' => array(
				"title" => esc_html__('Alter link', 'windsor'),
				"desc" => wp_kses_data( __('Color of the links inside block with alternative background', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_hover' => array(
				"title" => esc_html__('Alter hover', 'windsor'),
				"desc" => wp_kses_data( __('Color of the hovered links inside block with alternative background', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'scheme_info_input' => array(
				"title" => esc_html__('Colors for the form fields', 'windsor'),
				"desc" => wp_kses_data( __('Specify colors for the form fields and textareas', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
		
			'input_bg_color' => array(
				"title" => esc_html__('Inactive background', 'windsor'),
				"desc" => wp_kses_data( __('Background color of the inactive form fields', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_bg_hover' => array(
				"title" => esc_html__('Active background', 'windsor'),
				"desc" => wp_kses_data( __('Background color of the focused form fields', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_bd_color' => array(
				"title" => esc_html__('Inactive border', 'windsor'),
				"desc" => wp_kses_data( __('Color of the border in the inactive form fields', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_bd_hover' => array(
				"title" => esc_html__('Active border', 'windsor'),
				"desc" => wp_kses_data( __('Color of the border in the focused form fields', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_text' => array(
				"title" => esc_html__('Inactive field', 'windsor'),
				"desc" => wp_kses_data( __('Color of the text in the inactive fields', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_light' => array(
				"title" => esc_html__('Disabled field', 'windsor'),
				"desc" => wp_kses_data( __('Color of the disabled field', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_dark' => array(
				"title" => esc_html__('Active field', 'windsor'),
				"desc" => wp_kses_data( __('Color of the active field', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'scheme_info_inverse' => array(
				"title" => esc_html__('Colors for inverse blocks', 'windsor'),
				"desc" => wp_kses_data( __('Specify colors for inverse blocks, rectangular blocks with background color equal to the links color or one of accented colors (if used in the current theme)', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
		
			'inverse_text' => array(
				"title" => esc_html__('Inverse text', 'windsor'),
				"desc" => wp_kses_data( __('Color of the text inside block with accented background', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_light' => array(
				"title" => esc_html__('Inverse light', 'windsor'),
				"desc" => wp_kses_data( __('Color of the info blocks inside block with accented background', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_dark' => array(
				"title" => esc_html__('Inverse dark', 'windsor'),
				"desc" => wp_kses_data( __('Color of the headers inside block with accented background', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_link' => array(
				"title" => esc_html__('Inverse link', 'windsor'),
				"desc" => wp_kses_data( __('Color of the links inside block with accented background', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_hover' => array(
				"title" => esc_html__('Inverse hover', 'windsor'),
				"desc" => wp_kses_data( __('Color of the hovered links inside block with accented background', 'windsor') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$windsor_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),


			// Hidden options for override in the posts
			'media_title' => array(
				"title" => esc_html__('Media title', 'windsor'),
				"desc" => wp_kses_data( __('Used as title for the audio and video item in this post', 'windsor') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Title', 'windsor')
				),
				"hidden" => true,
				"std" => '',
				"type" => "text"
				),
			'media_author' => array(
				"title" => esc_html__('Media author', 'windsor'),
				"desc" => wp_kses_data( __('Used as author name for the audio and video item in this post', 'windsor') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Title', 'windsor')
				),
				"hidden" => true,
				"std" => '',
				"type" => "text"
				),

		));
	}
}
?>